/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

vec3 hsv(in float h, in float s, in float v) 

{
	return mix(vec3(1.0), clamp((abs(fract(h + vec3(3, 2, 1) / 3.0) * 6.0 - 3.0) - 1.0), 0.0 , 1.0), s) * v;
}	
	
void main() {
	float k = 10.0;
   vec2 q = gl_FragCoord.xy / iResolution.xy;
	vec4 p = vec4 ( -k + (2.0 * k) * q, 0.0, 0.0 );
	p.x *= iResolution.x / iResolution.y;
	vec4 c = vec4(sin(+iGlobalTime*0.2), 0.84, 0.0, 0.0);
	vec4 col = vec4(0);
	float t = iGlobalTime;
	for (int i = 4; i < 9; i++) 
	
	{
		p = abs(mod(p / dot(p,p) + c, 0.7) *1.6);
			col += max(p.x,max(p.x,p.p));
	}
	gl_FragColor = vec4(sin(col)*0.9+0.3);
}
